@echo off
rem
rem NeuroLoopGain reads an EEG signal and computes the loop gain of the underlying oscillating neural network.
rem The algorithm is described in the article:
rem - Kemp B, Zwinderman AH, Tuk B, Kamphuisen HAC, Obery JJL. 
rem - Analysis of a sleep-dependent neuronal feedback loop: the slow-wave microcontinuity of the EEG. 
rem - IEEE-BME 47(9), 2000: pp.1185-1194.
rem
rem The program can run on its own or be started by a batchfile like this one.
rem The input file must be in European Data Format (EDF, www.edfplus.info). Output files are also in EDF.
rem
rem The last two lines below are the actual batch-control. Its parameters are (in this example):
rem - The input files %%i are *.edf files in subdirectory PSGs.  
rem - The first  line computes spindle -loop gain of the first  signal (1) into outputfile PlotsIEEE\*.sg1
rem - The second line computes slowwave-loop gain of the second signal (2) into outputfile PlotsIEEE\*.dl1
rem - Spindle  parameters are 14Hz (in the article f0 on p.1186), 3.5Hz (B on p.1186) and 1.8Hz (fc on p.1188).
rem - Slowwave parameters are 01Hz (in the article f0 on p.1186), 1.5Hz (B on p.1186) and 1.8Hz (fc on p.1188).
rem - The smootherrate is 0.01666/s as on page 1190 of the article.
rem - Older output files are overwritten
rem - Every input sample is taken for the computation, so there is no undersampling (1)
rem - Analog low- and highpass filters of the EEG recorder had cut-offs at 80Hz and 0.03Hz respectively.
rem - Artifact detection thresholds xpibplus and xpibminus are +/-9, as in the article on p.1191 (top).
rem
rem The outputfile contains many signals. The signal that contains the neural loop gain has label "Gain"
rem and is expressed in %, ranging from 0% (no feedback, loop is open) to 100% (full feedback, loop is closed).
rem
rem The other signals contain intermediate computation results that may help you to reproduce this software.
rem I would be glad to assist with that: mail Bob Kemp, bk@hsr.nl
rem Some of those signals (not Gain) are logaritmically transformed in order to fit into EDF: 
rem see http://www.edfplus.info/specs/edffloat.html.
rem
rem Now the two actual batch control lines follow:
rem
for %%i in (PSGs\*.edf) do NeuroLoopGain %%i 1 PlotsIEEE\%%~ni.sg1 14 3.5 1.8 0.01666 /BATCH /OVERWRITE /UNDERSAMPLE=1 /LP:80.0 /HP:0.03 /xpibplus=9 /xpibminus=-9
for %%i in (PSGs\*.edf) do NeuroLoopGain %%i 2 PlotsIEEE\%%~ni.dl1 01 1.5 1.8 0.01666 /BATCH /OVERWRITE /UNDERSAMPLE=1 /LP:80.0 /HP:0.03 /xpibplus=9 /xpibminus=-9


